<?php
session_start();

require_once "../../config/db.php";
// Fetch all case_studies
$stmt = $pdo->query("SELECT * FROM case_studies ORDER BY created_at DESC");
$case_studies = $stmt->fetchAll();

if (!isset($_SESSION["admin_logged_in"])) {
  // Not logged in
  header("Location: /admin/login.php");
  exit;
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Success Story List</title>
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/slick.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
</head>
<body>
    <div class="body-bg">
        <?php include '../includes/sidebar.php'; ?>

        <section class="nftmax-adashboard nftmax-show">
        <div class="heading d-flex justify-content-between py-2">
        <h2>Success Story List</h2>
            <a href="create.php" class="h-auto w-auto btn-one">Add New Success Story</a>
        </div>

            <div class="row">
  <?php foreach ($case_studies as $case_studies): ?>
    <div class="col-md-4 mb-4">
      <div class="card h-100 shadow-sm">
        <?php if (!empty($case_studies['featured_image'])): ?>
          <img src="../<?= htmlspecialchars($case_studies['featured_image']) ?>" 
               class="card-img-top" 
               alt="<?= htmlspecialchars($case_studies['title']) ?>">
        <?php endif; ?>

        <div class="card-body d-flex flex-column">
          <h5 class="card-title"><?= htmlspecialchars($case_studies['title']) ?></h5>
          <p class="card-text text-muted">
            <?= htmlspecialchars(substr(strip_tags($case_studies['content']), 0, 100)) ?>...
          </p>

          <div class="mt-auto">

            <div class="d-flex gap-2">
              <a href="edit.php?id=<?= $case_studies['id'] ?>" 
                 class="btn btn-dark btn-sm flex-fill">
                Edit
              </a>
              <a href="delete.php?id=<?= $case_studies['id'] ?>" 
                 class="btn btn-danger btn-sm flex-fill" 
                 onclick="return confirm('Delete this Success Story?')">
                Delete
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

        </section>
    </div>


    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="../assets/js/jquery-3.6.3.min.js"></script>
  <script src="../assets/js/slick.min.js"></script>
  <script src="../assets/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/js/chart.js"></script>
  <script src="../assets/js/custom.js"></script>
  <script src="../assets/js/modeControl.js"></script>
</body>
</html>
