<?php
session_start();

require_once "../../config/db.php";


// Function to create slug
function slugify($text) {
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    $text = preg_replace('~-+~', '-', $text);
    return strtolower($text);
}

// CREATE
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    $slug = slugify($name);

    $stmt = $pdo->prepare("INSERT INTO categories (name, slug) VALUES (?, ?)");
    $stmt->execute([$name, $slug]);
}

// UPDATE
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $name = trim($_POST['name']);
    $slug = slugify($name);

    $stmt = $pdo->prepare("UPDATE categories SET name=?, slug=? WHERE id=?");
    $stmt->execute([$name, $slug, $id]);
}

// DELETE
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM categories WHERE id=?");
    $stmt->execute([$id]);
}

// READ
$stmt = $pdo->query("SELECT * FROM categories ORDER BY id DESC");
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!isset($_SESSION["admin_logged_in"])) {
    // Not logged in
    header("Location: /admin/login.php");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Manage Categories</title>

    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/slick.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
</head>
<body>
    <div class="body-bg">
        <?php include '../includes/sidebar.php'; ?>


        <section class="nftmax-adashboard nftmax-show">

        <h2>Manage Categories</h2>

        <!-- Add Form -->
        <form method="post" class="mb-3 mt-3">
        <input class="form-control w-auto d-inline-block" type="text" name="name" placeholder="Category name" required>
        <button class="h-auto w-auto btn-one" type="submit" name="add">Add</button>
    </form>

    <!-- Table -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Category</th>
                <th>Slug</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($categories as $cat): ?>
                <tr>
                    <td><?= htmlspecialchars($cat['name']) ?></td>
                    <td><?= htmlspecialchars($cat['slug']) ?></td>
                    <td>
                        <!-- Edit Form -->
                        <form method="post" class="d-inline-block">
                            <input type="hidden" name="id" value="<?= $cat['id'] ?>">
                            <input class="form-control d-inline-block w-auto" type="text" name="name" value="<?= htmlspecialchars($cat['name']) ?>" required>
                            <button class="w-auto btn btn-dark btn-sm" type="submit" name="update">Update</button>
                        </form>

                        <!-- Delete -->
                        <a href="?delete=<?= $cat['id'] ?>" class="w-auto btn btn-danger btn-sm" onclick="return confirm('Delete this category?')">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
    </section>


    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="../assets/js/jquery-3.6.3.min.js"></script>
  <script src="../assets/js/slick.min.js"></script>
  <script src="../assets/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/js/chart.js"></script>
  <script src="../assets/js/custom.js"></script>
  <script src="../assets/js/modeControl.js"></script>
</body>
</html>
