<?php
session_start();
require_once "../config/db.php";

// Already logged in
if (isset($_SESSION["admin_logged_in"])) {
    if ($_SESSION["admin_role"] === "superadmin") {
        header("Location: index.php");
    } else {
        header("Location: products");
    }
    exit;
}

$error = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST["username"]);
    $password = $_POST["password"];

    $stmt = $pdo->prepare("SELECT * FROM admins WHERE username = ?");
    $stmt->execute([$username]);
    $admin = $stmt->fetch();

    if ($admin && $password === $admin["password"]) { // 🔒 later replace with password_verify()
        $_SESSION["admin_logged_in"] = true;
        $_SESSION["admin_id"] = $admin["id"];
        $_SESSION["admin_role"] = $admin["role"]; // store role

        // Remember me
        if (!empty($_POST["remember"])) {
            $token = bin2hex(random_bytes(16));
            setcookie("remember_token", $token, time() + (30 * 24 * 60 * 60), "/");

            $update = $pdo->prepare("UPDATE admins SET remember_token = ? WHERE id = ?");
            $update->execute([$token, $admin["id"]]);
        }

        // Redirect by role
        if ($admin["role"] === "superadmin") {
            header("Location: index.php");
        } else {
            header("Location: products");
        }
        exit;
    } else {
        $error = "Invalid username or password.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    * { box-sizing: border-box; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
    body { margin: 0; background: #f0f2f5; display: flex; justify-content: center; align-items: center; height: 100vh; }
    .login-container { background: #fff; padding: 40px 30px; border-radius: 10px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); max-width: 400px; width: 100%; }
    .login-container h2 { text-align: center; margin-bottom: 30px; color: #333; }
    .login-container input[type="text"], .login-container input[type="password"] { width: 100%; padding: 12px; margin: 10px 0; border: 1px solid #ccc; border-radius: 6px; font-size: 16px; }
    .login-container label { font-size: 14px; display: flex; align-items: center; margin: 10px 0; color: #555; }
    .login-container input[type="checkbox"] { margin-right: 8px; }
    .login-container input[type="submit"] { width: 100%; padding: 12px; background: #007bff; color: white; border: none; border-radius: 6px; font-size: 16px; cursor: pointer; margin-top: 15px; transition: background 0.3s ease; }
    .login-container input[type="submit"]:hover { background: #0056b3; }
    .error-message { color: red; text-align: center; margin-bottom: 15px; }
  </style>
</head>
<body>
  <div class="login-container">
    <h2>Admin Login</h2>
    <?php if (!empty($error)) echo "<p class='error-message'>$error</p>"; ?>
    <form method="POST">
      <input type="text" name="username" placeholder="Username" required />
      <input type="password" name="password" placeholder="Password" required />
      <label><input type="checkbox" name="remember"> Remember Me</label>
      <input type="submit" value="Login" />
    </form>
  </div>
</body>
</html>
