<?php
session_start();
require_once "../../config/db.php";

if (!isset($_SESSION["admin_logged_in"])) {
    header("Location: /admin/login.php");
    exit;
}

$base = "/infyniaa/admin"; 

// 🔹 Pagination setup
$limit = 15; // products per page
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $limit;

// 🔹 Search setup
$search = $_GET['search'] ?? '';
$searchSql = "";
$params = [];

if (!empty($search)) {
    $searchSql = "WHERE p.name LIKE :search OR c.name LIKE :search";
    $params[':search'] = "%$search%";
}

// 🔹 Count total for pagination
$countSql = "SELECT COUNT(*) 
             FROM products p 
             LEFT JOIN categories c ON p.category_id = c.id 
             $searchSql";
$stmt = $pdo->prepare($countSql);
$stmt->execute($params);
$totalProducts = $stmt->fetchColumn();
$totalPages = ceil($totalProducts / $limit);

// 🔹 Fetch paginated products
$sql = "SELECT p.*, c.name AS category_name 
        FROM products p
        LEFT JOIN categories c ON p.category_id = c.id
        $searchSql
        ORDER BY p.id DESC
        LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($sql);

// bind values safely
foreach ($params as $k => $v) {
    $stmt->bindValue($k, $v, PDO::PARAM_STR);
}
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);

$stmt->execute();
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>


<!DOCTYPE html>
<html>
<head>
    <title>Manage Portfolio</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/slick.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
</head>
<body>
<div class="body-bg">
    <?php include '../includes/sidebar.php'; ?>

    <section class="nftmax-adashboard nftmax-show">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Manage Portfolio</h3>
            <a href="<?= $base ?>/all-product-page.php" style="display: block; width: auto; color: black !important; text-decoration:underline" type="submit">View Generated Project Pages</a>
            <a href="product.php" class="h-auto w-auto btn-one">+ Add Project</a>
        </div>

            <!-- 🔎 Search form -->
    <form method="get" class="mb-3 d-flex">
        <input type="text" name="search" class="form-control me-2" placeholder="Search Project or category..." value="<?= htmlspecialchars($search) ?>">
        <button type="submit" class="btn btn-dark">Search</button>
    </form>

        <div class="table-responsive">
            <?php if (count($products) > 0): ?>
                <table class="table table-bordered table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>Game Name</th>
                            <th>Category</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($products as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['name']) ?></td>
                                <td><?= $row['category_name'] ?? 'Uncategorized' ?></td>
                                <td>
                                    <a href="product.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-dark">Edit</a>
                                    <a href="delete.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="alert alert-info text-center">
                    No Projects found. <a href="product.php" class="alert-link">Add your first Game</a>.
                </div>
            <?php endif; ?>

                        <!-- 🔹 Pagination -->
                        <nav>
              <ul class="pagination">
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                  <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
                  </li>
                <?php endfor; ?>
              </ul>
            </nav>
        </div>
    </section>
</div>
<script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="../assets/js/jquery-3.6.3.min.js"></script>
  <script src="../assets/js/slick.min.js"></script>
  <script src="../assets/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/js/chart.js"></script>
  <script src="../assets/js/custom.js"></script>
  <script src="../assets/js/modeControl.js"></script>
</body>
</html>
