<?php
session_start();

require_once "../../config/db.php";

// Function to create slug
function slugify($text) {
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    $text = preg_replace('~-+~', '-', $text);
    return strtolower($text);
}

// CREATE
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    $slug = slugify($name);

    $stmt = $pdo->prepare("INSERT INTO secondary_keyword (name, slug) VALUES (?, ?)");
    $stmt->execute([$name, $slug]);
}

// UPDATE
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $name = trim($_POST['name']);
    $slug = slugify($name);

    $stmt = $pdo->prepare("UPDATE secondary_keyword SET name=?, slug=? WHERE id=?");
    $stmt->execute([$name, $slug, $id]);
}

// DELETE
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM secondary_keyword WHERE id=?");
    $stmt->execute([$id]);
}

// READ
$stmt = $pdo->query("SELECT * FROM secondary_keyword ORDER BY id DESC");
$secondary_keyword = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!isset($_SESSION["admin_logged_in"])) {
    // Not logged in
    header("Location: /admin/login.php");
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Manage Secondary Keyword</title>

    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/slick.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/responsive.css">
</head>
<body>
    <div class="body-bg">
        <?php include '../includes/sidebar.php'; ?>


        <section class="nftmax-adashboard nftmax-show">

        <h2>Manage Secondary Keyword</h2>

        <!-- Add Form -->
        <form method="post" class="mb-3 mt-3">
        <input class="form-control w-auto d-inline-block" type="text" name="name" placeholder="Subcategory name" required>
        <button class="h-auto w-auto btn-one" type="submit" name="add">Add</button>
    </form>

    <!-- Table -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Subcategory</th>
                <th>Slug</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($secondary_keyword as $sub): ?>
                <tr>
                    <td><?= htmlspecialchars($sub['name']) ?></td>
                    <td><?= htmlspecialchars($sub['slug']) ?></td>
                    <td>
                        <!-- Edit Form -->
                        <form method="post" class="d-inline-block">
                            <input type="hidden" name="id" value="<?= $sub['id'] ?>">
                            <input class="form-control d-inline-block w-auto" type="text" name="name" value="<?= htmlspecialchars($sub['name']) ?>" required>
                            <button class="w-auto btn btn-dark btn-sm" type="submit" name="update">Update</button>
                        </form>

                        <!-- Delete -->
                        <a href="?delete=<?= $sub['id'] ?>" class="w-auto btn btn-danger btn-sm" onclick="return confirm('Delete this subcategory?')">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</section>
    </div>


    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="../assets/js/jquery-3.6.3.min.js"></script>
  <script src="../assets/js/slick.min.js"></script>
  <script src="../assets/js/bootstrap.bundle.min.js"></script>
  <script src="../assets/js/chart.js"></script>
  <script src="../assets/js/custom.js"></script>
  <script src="../assets/js/modeControl.js"></script>
</body>
</html>
